--- Function to Make VSP Surfaces Material
fn DYNFUNmakeCivilViewSurfaces FUNpath =
(
  local LOCmat

  --- Open CivilViewSurfaces Material Library File
  local LOCcivilViewSurfacesMatFile = "$matlibs\\" + DYNmatNameSurfaces + ".mat"
  local LOCcivilViewSurfacesMatLib  = loadTempMaterialLibrary LOCcivilViewSurfacesMatFile

  if doesFileExist LOCcivilViewSurfacesMatFile and LOCcivilViewSurfacesMatLib != undefined then
  (
    for i = 1 to LOCcivilViewSurfacesMatLib.count do
    (
      if LOCcivilViewSurfacesMatLib[i].name == DYNmatNameSurfaces and classOf LOCcivilViewSurfacesMatLib[i] == Multimaterial then LOCmat = LOCcivilViewSurfacesMatLib[i]
    )
  )

  --- If It Didn't Exist In The Material Library, Create A Fresh Material Now
  if LOCmat == undefined then
  (
    --- Create Material If Doesn't Already Exist
    LOCmat          = multiMaterial()
    LOCmat.name     = DYNmatNameSurfaces
    LOCmat.count    = 50

    --- Define Diffuse Maps Array
    local LOCdiffMaps   = #() ; LOCdiffMaps[50] = undefined
    LOCdiffMaps[1]  = FUNpath + "RoadwayAsphalt01.png"
    LOCdiffMaps[2]  = FUNpath + "RoadwayAsphalt01.png"
    LOCdiffMaps[3]  = FUNpath + "RoadwayAsphalt01.png"
    LOCdiffMaps[4]  = FUNpath + "RoadwayAsphalt01.png"
    LOCdiffMaps[5]  = FUNpath + "RoadwayAsphalt01.png"
    LOCdiffMaps[6]  = FUNpath + "Kerb.jpg"
    LOCdiffMaps[7]  = FUNpath + "AsphaltBasic.png"
    LOCdiffMaps[8]  = FUNpath + "RoadwayAsphalt02.png"
    LOCdiffMaps[9]  = FUNpath + "RoadwayAsphalt02.png"
    LOCdiffMaps[10] = FUNpath + "RoadwayAsphalt02.png"
    LOCdiffMaps[11] = FUNpath + "RoadwayAsphalt02.png"
    LOCdiffMaps[12] = FUNpath + "RoadwayAsphalt02.png"
    LOCdiffMaps[13] = FUNpath + "RoadwayConcrete01.png"
    LOCdiffMaps[14] = FUNpath + "RoadwayConcrete01.png"
    LOCdiffMaps[15] = FUNpath + "RoadwayConcrete01.png"
    LOCdiffMaps[16] = FUNpath + "RoadwayConcrete01.png"
    LOCdiffMaps[17] = FUNpath + "RoadwayConcrete01.png"
    LOCdiffMaps[18] = FUNpath + "AsphaltBasic.png"
    LOCdiffMaps[19] = FUNpath + "Red.Asphalt.png"
    LOCdiffMaps[20] = undefined -- ok
    LOCdiffMaps[21] = undefined -- ok
    LOCdiffMaps[22] = FUNpath + "Concrete.Cast-In-Place.Exposed Aggregate.Medium.jpg"
    LOCdiffMaps[23] = undefined -- ok
    LOCdiffMaps[24] = undefined -- ok
    LOCdiffMaps[25] = undefined -- ok
    LOCdiffMaps[26] = FUNpath + "Grass.jpg"
    LOCdiffMaps[27] = FUNpath + "Grass.jpg"
    LOCdiffMaps[28] = FUNpath + "Grass.jpg"
    LOCdiffMaps[29] = undefined -- ok
    LOCdiffMaps[30] = undefined -- ok
    LOCdiffMaps[31] = undefined -- ok
    LOCdiffMaps[32] = FUNpath + "gravel.jpg"
    LOCdiffMaps[33] = undefined -- ok
    LOCdiffMaps[34] = FUNpath + "Grass.jpg"
    LOCdiffMaps[35] = FUNpath + "SiteWork.Planting.Grass.StAugustine1.jpg"
    LOCdiffMaps[36] = FUNpath + "Sitework.Planting.Sand.jpg"
    LOCdiffMaps[37] = FUNpath + "Concrete.Cast-In-Place.Exposed Aggregate.Medium.jpg"
    LOCdiffMaps[38] = FUNpath + "Concrete.Cast-In-Place.Exposed Aggregate.Recessed.jpg"
    LOCdiffMaps[39] = FUNpath + "Asphalt.Zoab.png"
    LOCdiffMaps[40] = FUNpath + "Asphalt.Alt.png"
    LOCdiffMaps[41] = FUNpath + "Masonry.Stone.Granite.Square.Stacked.Polished.Grey.jpg"
    LOCdiffMaps[42] = FUNpath + "Sitework.Paving & Surfacing.Pavers.Terra Cotta.jpg"
    LOCdiffMaps[43] = FUNpath + "Brick_Herringbone_Red.jpg"
    LOCdiffMaps[44] = FUNpath + "Brick_Herringbone_Gray.jpg"
    LOCdiffMaps[45] = FUNpath + "Masonry.Unit Masonry.Brick.Modular.Herringbone.jpg"
    LOCdiffMaps[46] = FUNpath + "Sitework.Paving & Surfacing.Pavers.3.jpg"
    LOCdiffMaps[47] = FUNpath + "Paving.Flags.png"
    LOCdiffMaps[48] = FUNpath + "Masonry.Unit Masonry.Brick.Modular.Herringbone.1.jpg"
    LOCdiffMaps[49] = FUNpath + "Sitework.Paving & Surfacing.Cobble Stone.Heringbone.jpg"
    LOCdiffMaps[50] = FUNpath + "Concrete.Cast-In-Place.SandBlasted.jpg"

    --- Define Diffuse Maps Array
    local LOCbumpMaps   = #() ; LOCbumpMaps[50] = undefined
    LOCbumpMaps[34] = FUNpath + "SiteWork.Planting.Grass.StAugustine.Bump1.jpg"
    LOCbumpMaps[35] = FUNpath + "SiteWork.Planting.Grass.StAugustine.Bump1.jpg"
    LOCbumpMaps[36] = FUNpath + "Sitework.Planting.Sand.jpg"
    LOCbumpMaps[37] = FUNpath + "Concrete.Cast-In-Place.Exposed Aggregate.Medium.bump.jpg"
    LOCbumpMaps[38] = FUNpath + "Concrete.Cast-In-Place.Exposed Aggregate.Recessed.Bump.jpg"
    LOCbumpMaps[39] = FUNpath + "Asphalt.Zoab.Bump.png"
    LOCbumpMaps[40] = FUNpath + "Asphalt.Alt.Bump.png"
    LOCbumpMaps[41] = FUNpath + "Masonry.Stone.Granite.Square.Stacked.Polished.Grey.jpg"
    LOCbumpMaps[42] = FUNpath + "Sitework.Paving & Surfacing.Pavers.Terra Cotta.bump.jpg"
    LOCbumpMaps[43] = FUNpath + "Brick_Herringbone.bump.jpg"
    LOCbumpMaps[44] = FUNpath + "Brick_Herringbone.bump.jpg"
    LOCbumpMaps[45] = FUNpath + "Brick_Herringbone.bump.jpg"
    LOCbumpMaps[46] = FUNpath + "Sitework.Paving & Surfacing.Pavers.3.bump.jpg"
    LOCbumpMaps[47] = FUNpath + "Paving.Flags.Bump.png"
    LOCbumpMaps[48] = FUNpath + "Masonry.Unit Masonry.Brick.Modular.Herringbone.1.bump.jpg"
    LOCbumpMaps[49] = FUNpath + "Sitework.Paving & Surfacing.Cobble Stone.Heringbone.bump.jpg"
    LOCbumpMaps[50] = FUNpath + "Concrete.Cast-In-Place.SandBlasted.Bump.jpg"

    --- Define Opacity Maps Array
    local LOCopacMaps   = #() ; LOCopacMaps[50] = undefined
    LOCopacMaps[29] = FUNpath + "OpacityRailing.gif"
    LOCopacMaps[30] = FUNpath + "PedestrianRailing.png"

    --- Define Noise Map for Asphalt
    local LOCasphaltNoiseMap          = Noise()
    LOCasphaltNoiseMap.name           = DYNuiResourcesMaterialMaps[1]
    LOCasphaltNoiseMap.type           = 0 -- (0:Regular; 1:Fractal; 2:Turbulance)
    LOCasphaltNoiseMap.size           = 0.2
    LOCasphaltNoiseMap.color1         = color 170 153 153
    LOCasphaltNoiseMap.color2         = color   0   0   0
    LOCasphaltNoiseMap.phase          = 0.0
    LOCasphaltNoiseMap.levels         = 3.0
    LOCasphaltNoiseMap.thresholdLow   = 0.0
    LOCasphaltNoiseMap.thresholdHigh  = 1.0
    LOCasphaltNoiseMap.coords.blur    = 1.0

    --- Define Noise Map for Concrete
    local LOCconcreteNoiseMap         = Noise()
    LOCconcreteNoiseMap.name          = DYNuiResourcesMaterialMaps[2]
    LOCconcreteNoiseMap.type          = 1 -- (0:Regular; 1:Fractal; 2:Turbulance)
    LOCconcreteNoiseMap.size          = 0.5
    LOCconcreteNoiseMap.color1        = color 115 110 110
    LOCconcreteNoiseMap.color2        = color 255 255 255
    LOCconcreteNoiseMap.phase         = 0.0
    LOCconcreteNoiseMap.levels        = 1.0
    LOCconcreteNoiseMap.thresholdLow  = 0.0
    LOCconcreteNoiseMap.thresholdHigh = 1.0
    LOCconcreteNoiseMap.coords.blur   = 1.0

    --- Define Noise Map for Paving
    local LOCpavingNoiseMap           = Noise()
    LOCpavingNoiseMap.name            = DYNuiResourcesMaterialMaps[3]
    LOCpavingNoiseMap.type            = 1 -- (0:Regular; 1:Fractal; 2:Turbulance)
    LOCpavingNoiseMap.size            = 1.0
    LOCpavingNoiseMap.color1          = color  55  55  65
    LOCpavingNoiseMap.color2          = color 195 195 205
    LOCpavingNoiseMap.phase           = 0.0
    LOCpavingNoiseMap.levels          = 3.0
    LOCpavingNoiseMap.thresholdLow    = 0.2
    LOCpavingNoiseMap.thresholdHigh   = 0.8
    LOCpavingNoiseMap.coords.blur     = 1.0

    --- Define Noise Map for Grass
    local LOCgrassNoiseMap            = Noise()
    LOCgrassNoiseMap.name             = DYNuiResourcesMaterialMaps[4]
    LOCgrassNoiseMap.type             = 1 -- (0:Regular; 1:Fractal; 2:Turbulance)
    LOCgrassNoiseMap.size             = 2.5
    LOCgrassNoiseMap.color1           = color 122 129 81
    LOCgrassNoiseMap.color2           = color 47 51 23
    LOCgrassNoiseMap.phase            = 2.0
    LOCgrassNoiseMap.levels           = 1.0
    LOCgrassNoiseMap.thresholdLow     = 0.0
    LOCgrassNoiseMap.thresholdHigh    = 1.0
    LOCgrassNoiseMap.coords.blur      = 1.0

    --- Define Smoke Map for Sand
    local LOCsandSmokeMap             = smoke()
    LOCsandSmokeMap.name              = DYNuiResourcesMaterialMaps[5]
    LOCsandSmokeMap.size              = 10.0
    LOCsandSmokeMap.color1            = color 208 227 105
    LOCsandSmokeMap.color2            = color 255 255 255
    LOCsandSmokeMap.phase             = 2.7
    LOCsandSmokeMap.iterations        = 3
    LOCsandSmokeMap.exponent          = 1.5

    /*---- A & D (DYNFUNbuildArchDesignMat) -----   ---- Standard (DYNFUNbuildStdMat) ---------------
      1: matName string                              1: matName string
      2: diffuseColor color                          2: ambientColor color
      3: diffuseMap map                              3: diffuseColor color
      4: bumpMap map                                 4: specularColor color
      5: cutOutMap map                               5: shaderType integer
      6: mapBlur float                               6: diffuseMap map
      7: useRealWorldScale boolean                   7: bumpMap map
      8: diffuseRough float                          8: cutOutMap map
      9: diffuseWeight float                         9: diffuseMapPercent integer
     10: reflWeight float                           10: bumpMapPercent integer
     11: reflGloss float                            11: mapBlur float
     12: reflSamples integer                        12: useRealWorldScale boolean
     13: metalReflectSwitch boolean                 13: specularPercent integer
     14: bumpMapPercent integer                     14: glossPercent integer
     15: anisoAmount float                          15: soften float
     16: anisoAngle float                           16: selfIllumPercent integer
     17: selfIllumSwitch boolean                    17: opacityPercent integer
     18: selfIllimAmount integer                    18: twoSided boolean
     19: selfIllumVisibleInScene boolean            19: wAngle float
     20: selfIllumVisibleInReflections boolean      20: overrideCutoutMapWithDiffuseAlpha
     21: bdrfDeg00 float                            21: uTiling float
     22: bdrfDeg90 float                            22: vTiling float
     23: bdrfCurveShape float                       23: uOffset float
     24: twoSided boolean                           24: vOffset float
     25: wAngle float                               25: diffuseMixMap
     26: overrideCutoutMapWithDiffuseAlpha boolean  26: diffuseMixAmount
     27: uTiling float
     28: vTiling float
     29: uOffset float
     30: vOffset float
     31: diffuseMixMap
     32: diffuseMixAmount                           */

    if (DYNFUNisMentalRayProductionRenderer()) then
    (
      LOCmat[1]  = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[1]  (color 250 250 250) LOCdiffMaps[1]  LOCbumpMaps[1]  LOCopacMaps[1]  1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  1.0  1.0 0.0 0.0   LOCasphaltNoiseMap 10.0
      LOCmat[2]  = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[2]  (color 250 250 250) LOCdiffMaps[2]  LOCbumpMaps[2]  LOCopacMaps[2]  1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  1.0  2.0 0.0 0.25  LOCasphaltNoiseMap 10.0
      LOCmat[3]  = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[3]  (color 250 250 250) LOCdiffMaps[3]  LOCbumpMaps[3]  LOCopacMaps[3]  1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  1.0  3.0 0.0 0.0   LOCasphaltNoiseMap 10.0
      LOCmat[4]  = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[4]  (color 250 250 250) LOCdiffMaps[4]  LOCbumpMaps[4]  LOCopacMaps[4]  1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  1.0  4.0 0.0 0.125 LOCasphaltNoiseMap 10.0
      LOCmat[5]  = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[5]  (color 250 250 250) LOCdiffMaps[5]  LOCbumpMaps[5]  LOCopacMaps[5]  1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  1.0  5.0 0.0 0.0   LOCasphaltNoiseMap 10.0
      LOCmat[6]  = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[6]  (color 250 250 250) LOCdiffMaps[6]  LOCbumpMaps[6]  LOCopacMaps[6]  1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  5.0  1.0 0.0 0.0   LOCasphaltNoiseMap 10.0
      LOCmat[7]  = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[7]  (color 250 250 250) LOCdiffMaps[7]  LOCbumpMaps[7]  LOCopacMaps[7]  1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  2.0  2.0 0.0 0.0   LOCasphaltNoiseMap 10.0
      LOCmat[8]  = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[8]  (color 250 250 250) LOCdiffMaps[8]  LOCbumpMaps[8]  LOCopacMaps[8]  1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  1.0  1.0 0.0 0.0   LOCasphaltNoiseMap 10.0
      LOCmat[9]  = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[9]  (color 250 250 250) LOCdiffMaps[9]  LOCbumpMaps[9]  LOCopacMaps[9]  1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  1.0  2.0 0.0 0.25  LOCasphaltNoiseMap 10.0
      LOCmat[10] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[10] (color 250 250 250) LOCdiffMaps[10] LOCbumpMaps[10] LOCopacMaps[10] 1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  1.0  3.0 0.0 0.0   LOCasphaltNoiseMap 10.0
      LOCmat[11] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[11] (color 250 250 250) LOCdiffMaps[11] LOCbumpMaps[11] LOCopacMaps[11] 1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  1.0  4.0 0.0 0.125 LOCasphaltNoiseMap 10.0
      LOCmat[12] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[12] (color 250 250 250) LOCdiffMaps[12] LOCbumpMaps[12] LOCopacMaps[12] 1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  1.0  5.0 0.0 0.0   LOCasphaltNoiseMap 10.0
      LOCmat[13] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[13] (color 250 250 250) LOCdiffMaps[13] LOCbumpMaps[13] LOCopacMaps[13] 1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  1.0  1.0 0.0 0.0   LOCasphaltNoiseMap 10.0
      LOCmat[14] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[14] (color 250 250 250) LOCdiffMaps[14] LOCbumpMaps[14] LOCopacMaps[14] 1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  1.0  2.0 0.0 0.25  LOCasphaltNoiseMap 10.0
      LOCmat[15] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[15] (color 250 250 250) LOCdiffMaps[15] LOCbumpMaps[15] LOCopacMaps[15] 1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  1.0  3.0 0.0 0.0   LOCasphaltNoiseMap 10.0
      LOCmat[16] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[16] (color 250 250 250) LOCdiffMaps[16] LOCbumpMaps[16] LOCopacMaps[16] 1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  1.0  4.0 0.0 0.125 LOCasphaltNoiseMap 10.0
      LOCmat[17] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[17] (color 250 250 250) LOCdiffMaps[17] LOCbumpMaps[17] LOCopacMaps[17] 1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  1.0  5.0 0.0 0.0   LOCasphaltNoiseMap 10.0
      LOCmat[18] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[18] (color 250 250 250) LOCdiffMaps[18] LOCbumpMaps[18] LOCopacMaps[18] 1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  2.0  2.0 0.0 0.0   LOCasphaltNoiseMap 10.0
      LOCmat[19] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[19] (color 110  65  65) LOCdiffMaps[19] LOCbumpMaps[19] LOCopacMaps[19] 1.0 false 0.2 0.9  0.0 1.0 8 false  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  5.0  5.0 0.0 0.0   LOCasphaltNoiseMap 10.0
      LOCmat[20] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[20] (color  47 143 112) LOCdiffMaps[20] LOCbumpMaps[20] LOCopacMaps[20] 1.0 false 0.0 0.02 1.0 1.0 8 false 18 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  1.0  1.0 0.0 0.0   undefined 0.0
      LOCmat[21] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[21] (color  47 143 112) LOCdiffMaps[21] LOCbumpMaps[21] LOCopacMaps[21] 1.0 false 0.0 0.02 1.0 1.0 8 false 18 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  1.0  1.0 0.0 0.0   undefined 0.0
      LOCmat[22] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[22] (color 105 105 105) LOCdiffMaps[22] LOCbumpMaps[22] LOCopacMaps[22] 1.0 false 0.2 1.0  0.0 1.0 8 false 35 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  1.0  1.0 0.0 0.0   LOCconcreteNoiseMap 40.0
      LOCmat[23] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[23] (color 128 128 128) LOCdiffMaps[23] LOCbumpMaps[23] LOCopacMaps[23] 1.0 false 0.2 1.0  0.0 1.0 8 false 35 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 90.0 false  1.0  1.0 0.0 0.0   undefined 0.0
      LOCmat[24] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[24] (color 147  44  56) LOCdiffMaps[24] LOCbumpMaps[24] LOCopacMaps[24] 1.0 false 0.2 1.0  0.0 1.0 8 false 35 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  1.0  1.0 0.0 0.0   undefined 0.0
      LOCmat[25] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[25] DYNINImarkingColor  LOCdiffMaps[25] LOCbumpMaps[25] LOCopacMaps[25] 1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  1.0  1.0 0.0 0.0   undefined 0.0
      LOCmat[26] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[26] (color 100 185  80) LOCdiffMaps[26] LOCbumpMaps[26] LOCopacMaps[26] 1.0 false 0.2 1.0  0.0 1.0 8 false 25 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  1.0  1.0 0.0 0.0   LOCgrassNoiseMap 40.0
      LOCmat[27] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[27] (color 100 185  80) LOCdiffMaps[27] LOCbumpMaps[27] LOCopacMaps[27] 1.0 false 0.2 1.0  0.0 1.0 8 false 25 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  1.0  1.0 0.0 0.0   LOCgrassNoiseMap 50.0
      LOCmat[28] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[28] (color 100 185  80) LOCdiffMaps[28] LOCbumpMaps[28] LOCopacMaps[28] 1.0 false 0.2 1.0  0.0 1.0 8 false 25 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  1.0  1.0 0.0 0.0   LOCgrassNoiseMap 60.0
      LOCmat[29] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[29] (color 210 210 210) LOCdiffMaps[29] LOCbumpMaps[29] LOCopacMaps[29] 0.5 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 true   0.0 true   1.0  5.0 0.0 0.0   undefined 0.0
      LOCmat[30] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[30] (color 210 210 210) LOCdiffMaps[30] LOCbumpMaps[30] LOCopacMaps[30] 0.5 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 true   0.0 true   1.0  8.0 0.0 0.0   undefined 0.0
      LOCmat[31] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[31] (color  75 110  70) LOCdiffMaps[31] LOCbumpMaps[31] LOCopacMaps[31] 0.6 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false 20.0 20.0 0.0 0.0   undefined 0.0
      LOCmat[32] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[32] (color 174 174 174) LOCdiffMaps[32] LOCbumpMaps[32] LOCopacMaps[32] 0.8 false 0.2 1.0  0.0 1.0 8 false 25 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  2.0  2.0 0.0 0.0   LOCgrassNoiseMap 30.0
      LOCmat[33] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[33] (color 130  95  85) LOCdiffMaps[33] LOCbumpMaps[33] LOCopacMaps[33] 1.0 false 0.2 1.0  0.0 1.0 8 false 25 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  1.0  1.0 0.0 0.0   undefined 0.0
      LOCmat[34] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[34] (color 100 185  80) LOCdiffMaps[34] LOCbumpMaps[34] LOCopacMaps[34] 1.0 false 0.2 1.0  0.0 1.0 8 false 40 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  1.0  1.0 0.0 0.0   LOCgrassNoiseMap 25.0
      LOCmat[35] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[35] (color 100 185  80) LOCdiffMaps[35] LOCbumpMaps[35] LOCopacMaps[35] 1.0 false 0.2 1.0  0.0 1.0 8 false 40 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  4.0  4.0 0.0 0.0   LOCgrassNoiseMap 25.0
      LOCmat[36] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[36] (color 219 220 145) LOCdiffMaps[36] LOCbumpMaps[36] LOCopacMaps[36] 1.0 false 0.2 1.0  0.0 1.0 8 false 40 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  2.0  2.0 0.0 0.0   LOCsandSmokeMap 30.0
      LOCmat[37] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[37] (color 105 105 105) LOCdiffMaps[37] LOCbumpMaps[37] LOCopacMaps[37] 1.0 false 0.2 1.0  0.0 1.0 8 false 35 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  1.0  1.0 0.0 0.0   LOCconcreteNoiseMap 35.0
      LOCmat[38] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[38] (color 105 105 105) LOCdiffMaps[38] LOCbumpMaps[38] LOCopacMaps[38] 1.0 false 0.2 1.0  0.0 1.0 8 false 35 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  1.0  1.0 0.0 0.0   LOCconcreteNoiseMap 25.0
      LOCmat[39] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[39] (color 185 175 175) LOCdiffMaps[39] LOCbumpMaps[39] LOCopacMaps[39] 1.0 false 0.2 1.0  0.0 1.0 8 false 35 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  4.0  4.0 0.0 0.0   undefined 0.0
      LOCmat[40] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[40] (color 145 145 145) LOCdiffMaps[40] LOCbumpMaps[40] LOCopacMaps[40] 1.0 false 0.2 1.0  0.0 1.0 8 false 35 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false  4.0  4.0 0.0 0.0   undefined 0.0
      LOCmat[41] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[41] (color 175 165 165) LOCdiffMaps[41] LOCbumpMaps[41] LOCopacMaps[41] 1.0 false 0.2 1.0  0.0 1.0 8 false 35 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false 10.0 10.0 0.0 0.0   LOCpavingNoiseMap 10.0
      LOCmat[42] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[42] (color 175 165 165) LOCdiffMaps[42] LOCbumpMaps[42] LOCopacMaps[42] 1.0 false 0.2 1.0  0.0 1.0 8 false 35 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false 10.0 10.0 0.0 0.0   LOCpavingNoiseMap 10.0
      LOCmat[43] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[43] (color 175 165 165) LOCdiffMaps[43] LOCbumpMaps[43] LOCopacMaps[43] 1.0 false 0.2 1.0  0.0 1.0 8 false 35 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false 10.0 10.0 0.0 0.0   LOCpavingNoiseMap 10.0
      LOCmat[44] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[44] (color 175 165 165) LOCdiffMaps[44] LOCbumpMaps[44] LOCopacMaps[44] 1.0 false 0.2 1.0  0.0 1.0 8 false 35 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false 10.0 10.0 0.0 0.0   LOCpavingNoiseMap 10.0
      LOCmat[45] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[45] (color 175 165 165) LOCdiffMaps[45] LOCbumpMaps[45] LOCopacMaps[45] 1.0 false 0.2 1.0  0.0 1.0 8 false 35 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false 10.0 10.0 0.0 0.0   LOCpavingNoiseMap 10.0
      LOCmat[46] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[46] (color 175 165 165) LOCdiffMaps[46] LOCbumpMaps[46] LOCopacMaps[46] 1.0 false 0.2 1.0  0.0 1.0 8 false 35 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false 10.0 10.0 0.0 0.0   LOCpavingNoiseMap 10.0
      LOCmat[47] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[47] (color 175 165 165) LOCdiffMaps[47] LOCbumpMaps[47] LOCopacMaps[47] 1.0 false 0.2 1.0  0.0 1.0 8 false 35 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false 10.0 10.0 0.0 0.0   LOCpavingNoiseMap 10.0
      LOCmat[48] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[48] (color 175 165 165) LOCdiffMaps[48] LOCbumpMaps[48] LOCopacMaps[48] 1.0 false 0.2 1.0  0.0 1.0 8 false 35 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false 10.0 10.0 0.0 0.0   LOCpavingNoiseMap 10.0
      LOCmat[49] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[49] (color 175 165 165) LOCdiffMaps[49] LOCbumpMaps[49] LOCopacMaps[49] 1.0 false 0.2 1.0  0.0 1.0 8 false 35 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false 20.0 20.0 0.0 0.0   LOCpavingNoiseMap 10.0
      LOCmat[50] = DYNFUNbuildArchDesignMat DYNuiResourcesSurfaceMaterial[50] (color 175 165 165) LOCdiffMaps[50] LOCbumpMaps[50] LOCopacMaps[50] 1.0 false 0.2 1.0  0.0 1.0 8 false 35 1.0 0.0 false 0 false false 0.2 1.0 5.0 false  0.0 false 10.0 10.0 0.0 0.0   LOCpavingNoiseMap 10.0

      --- Extra Bits
      LOCmat.materiallist[31].diff_color_map                   = checker()
      LOCmat.materiallist[31].diff_color_map.coords.U_tiling   = 20.0
      LOCmat.materiallist[31].diff_color_map.coords.V_tiling   = 20.0

      --- Paving Type 1 Channel (23)
      LOCmat.materialList[23].diff_color_map                   = Bricks()
      LOCmat.materialList[23].diff_color_map.brick_color       = color 130 125 119
      LOCmat.materialList[23].diff_color_map.horizontal_count  = 12.0
      LOCmat.materialList[23].diff_color_map.vertical_count    = 32.0
      LOCmat.materialList[23].diff_color_map.color_variance    = 0.1
      LOCmat.materialList[23].diff_color_map.fade_variance     = 0.1
      LOCmat.materialList[23].diff_color_map.mortar_color      = color 72 66 54
      LOCmat.materialList[23].diff_color_map.horizontal_gap    = 0.1
      LOCmat.materialList[23].diff_color_map.vertical_gap      = 0.1
      LOCmat.materialList[23].diff_color_map.lock_gap_symmetry = 1
      LOCmat.materialList[23].diff_color_map.holes             = 0
      LOCmat.materialList[23].diff_color_map.edge_roughness    = 5.0
      LOCmat.materialList[23].diff_color_map.random_seed       = 41955
      LOCmat.materiallist[23].diff_color_map.coords.W_angle    = 90.0
      LOCmat.materialList[23].diff_color_map.tile_type         = 1 -- Running Bond
      LOCmat.materialList[23].bump_map                         = Bricks()
      LOCmat.materialList[23].bump_map.brick_color             = color 215 215 215
      LOCmat.materialList[23].bump_map.horizontal_count        = 12.0
      LOCmat.materialList[23].bump_map.vertical_count          = 32.0
      LOCmat.materialList[23].bump_map.color_variance          = 0.0
      LOCmat.materialList[23].bump_map.fade_variance           = 0.0
      LOCmat.materialList[23].bump_map.mortar_color            = color 44 37 23
      LOCmat.materialList[23].bump_map.horizontal_gap          = 0.1
      LOCmat.materialList[23].bump_map.vertical_gap            = 0.1
      LOCmat.materialList[23].bump_map.lock_gap_symmetry       = 1
      LOCmat.materialList[23].bump_map.holes                   = 0
      LOCmat.materialList[23].bump_map.edge_roughness          = 2.0
      LOCmat.materialList[23].bump_map.random_seed             = 41955
      LOCmat.materiallist[23].bump_map.coords.W_angle          = 90.0
      LOCmat.materialList[23].bump_map.tile_type               = 1 -- Running Bond

      --- Paving Type 2 Channel (24)
      LOCmat.materialList[24].diff_color_map                   = Bricks()
      LOCmat.materialList[24].diff_color_map.brick_color       = color 121 52 57
      LOCmat.materialList[24].diff_color_map.horizontal_count  = 50.0
      LOCmat.materialList[24].diff_color_map.vertical_count    = 35.0
      LOCmat.materialList[24].diff_color_map.color_variance    = 0.1
      LOCmat.materialList[24].diff_color_map.fade_variance     = 0.2
      LOCmat.materialList[24].diff_color_map.mortar_color      = color 56 51 42
      LOCmat.materialList[24].diff_color_map.horizontal_gap    = 0.1
      LOCmat.materialList[24].diff_color_map.vertical_gap      = 0.1
      LOCmat.materialList[24].diff_color_map.lock_gap_symmetry = 1
      LOCmat.materialList[24].diff_color_map.holes             = 0
      LOCmat.materialList[24].diff_color_map.edge_roughness    = 5.0
      LOCmat.materialList[24].diff_color_map.random_seed       = 41955
      LOCmat.materialList[24].diff_color_map.tile_type         = 1 -- Running Bond
      LOCmat.materialList[24].bump_map                         = Bricks()
      LOCmat.materialList[24].bump_map.brick_color             = color 215 215 215
      LOCmat.materialList[24].bump_map.horizontal_count        = 50.0
      LOCmat.materialList[24].bump_map.vertical_count          = 35.0
      LOCmat.materialList[24].bump_map.color_variance          = 0.0
      LOCmat.materialList[24].bump_map.fade_variance           = 0.0
      LOCmat.materialList[24].bump_map.mortar_color            = color 44 37 24
      LOCmat.materialList[24].bump_map.horizontal_gap          = 0.1
      LOCmat.materialList[24].bump_map.vertical_gap            = 0.1
      LOCmat.materialList[24].bump_map.lock_gap_symmetry       = 1
      LOCmat.materialList[24].bump_map.holes                   = 0
      LOCmat.materialList[24].bump_map.edge_roughness          = 2.0
      LOCmat.materialList[24].bump_map.random_seed             = 41955
      LOCmat.materialList[24].bump_map.tile_type               = 1 -- Running Bond

      --- Water 20/21
      for ii = 20 to 21 do
      (
        LOCmat.materialList[ii].refl_color = (color 255 255 255) -- Color
        LOCmat.materialList[ii].refl_interp = false -- BooleanClass
        LOCmat.materialList[ii].refl_hlonly = false -- BooleanClass
        LOCmat.materialList[ii].refl_metal = false -- BooleanClass
        LOCmat.materialList[ii].refr_color = (color 255 255 255) -- Color
        LOCmat.materialList[ii].refr_gloss = 1.0 -- Float
        LOCmat.materialList[ii].refr_samples = 8 -- Integer
        LOCmat.materialList[ii].refr_interp = false -- BooleanClass
        LOCmat.materialList[ii].refr_ior = 1.33 -- Float
        LOCmat.materialList[ii].refr_weight = 0.0 -- Float
        LOCmat.materialList[ii].refr_trans_on = false -- BooleanClass
        LOCmat.materialList[ii].refr_transc = (color 178.5 127.5 51) -- Color
        LOCmat.materialList[ii].refr_transw = 0.5 -- Float
        LOCmat.materialList[ii].aniso_mode = 0 -- Integer
        LOCmat.materialList[ii].aniso_channel = 0 -- Integer
        LOCmat.materialList[ii].refl_func_fresnel = true -- BooleanClass
        LOCmat.materialList[ii].refl_func_low = 0.2 -- Float
        LOCmat.materialList[ii].refl_func_high = 1.0 -- Float
        LOCmat.materialList[ii].refl_func_curve = 5.0 -- Float
        LOCmat.materialList[ii].refl_falloff_on = false -- BooleanClass
        LOCmat.materialList[ii].refl_falloff_dist = 0.0 -- Float
        LOCmat.materialList[ii].refl_falloff_color_on = false -- BooleanClass
        LOCmat.materialList[ii].refl_falloff_color = (color 51 51 51) -- Color
        LOCmat.materialList[ii].opts_refl_depth = 4 -- Integer
        LOCmat.materialList[ii].refl_cutoff = 0.01 -- Float
        LOCmat.materialList[ii].refr_falloff_on = false -- BooleanClass
        LOCmat.materialList[ii].refr_falloff_dist = 0.0 -- Float
        LOCmat.materialList[ii].refr_falloff_color_on = false -- BooleanClass
        LOCmat.materialList[ii].refr_falloff_color = (color 51 51 51) -- Color
        LOCmat.materialList[ii].opts_refr_depth = 6 -- Integer
        LOCmat.materialList[ii].refr_cutoff = 0.01 -- Float
        LOCmat.materialList[ii].opts_indirect_multiplier = 1.0 -- Float
        LOCmat.materialList[ii].opts_fg_quality = 1.0 -- Float
        LOCmat.materialList[ii].inter_density = 2 -- Integer
        LOCmat.materialList[ii].intr_refl_samples = 2 -- Integer
        LOCmat.materialList[ii].intr_refl_ddist_on = false -- BooleanClass
        LOCmat.materialList[ii].intr_refl_ddist = 0.0 -- Float
        LOCmat.materialList[ii].intr_refr_samples = 2 -- Integer
        LOCmat.materialList[ii].single_env_sample = false -- BooleanClass
        LOCmat.materialList[ii].opts_round_corners_on = false -- BooleanClass
        LOCmat.materialList[ii].opts_round_corners_radius = 10.0 -- Float
        LOCmat.materialList[ii].opts_round_corners_any_mtl = true -- BooleanClass
        LOCmat.materialList[ii].opts_ao_on = false -- BooleanClass
        LOCmat.materialList[ii].opts_ao_use_global_ambient = false -- BooleanClass
        LOCmat.materialList[ii].opts_ao_samples = 16 -- Integer
        LOCmat.materialList[ii].opts_ao_distance = 4.0 -- Float
        LOCmat.materialList[ii].opts_ao_dark = (color 51 51 51) -- Color
        LOCmat.materialList[ii].opts_ao_ambient = (color 0 0 0) -- Color
        LOCmat.materialList[ii].opts_ao_do_details = true -- BooleanClass
        LOCmat.materialList[ii].opts_no_area_hl = true -- BooleanClass
        LOCmat.materialList[ii].opts_1sided = false -- BooleanClass
        LOCmat.materialList[ii].opts_do_refractive_caustics = false -- BooleanClass
        LOCmat.materialList[ii].opts_skip_inside = true -- BooleanClass
        LOCmat.materialList[ii].opts_backface_cull = false -- BooleanClass
        LOCmat.materialList[ii].opts_propagate_alpha = false -- BooleanClass
        LOCmat.materialList[ii].no_diffuse_bump = true -- BooleanClass
        LOCmat.materialList[ii].bump_map = Ocean__lume()
        LOCmat.materialList[ii].diff_color_map_on = true -- BooleanClass
        LOCmat.materialList[ii].diff_rough_map_on = true -- BooleanClass
        LOCmat.materialList[ii].refl_color_map_on = true -- BooleanClass
        LOCmat.materialList[ii].refl_gloss_map_on = true -- BooleanClass
        LOCmat.materialList[ii].refr_color_map_on = true -- BooleanClass
        LOCmat.materialList[ii].refr_gloss_map_on = true -- BooleanClass
        LOCmat.materialList[ii].refr_ior_map_on = true -- BooleanClass
        LOCmat.materialList[ii].refr_transc_map_on = true -- BooleanClass
        LOCmat.materialList[ii].refr_transw_map_on = true -- BooleanClass
        LOCmat.materialList[ii].anisotropy_map_on = true -- BooleanClass
        LOCmat.materialList[ii].anisoangle_map_on = true -- BooleanClass
        LOCmat.materialList[ii].refl_falloff_color_map_on = true -- BooleanClass
        LOCmat.materialList[ii].refr_falloff_color_map_on = true -- BooleanClass
        LOCmat.materialList[ii].indirect_multiplier_map_on = true -- BooleanClass
        LOCmat.materialList[ii].fg_quality_map_on = true -- BooleanClass
        LOCmat.materialList[ii].ao_dark_map_on = true -- BooleanClass
        LOCmat.materialList[ii].ao_ambient_map_on = true -- BooleanClass
        LOCmat.materialList[ii].bump_map_on = true -- BooleanClass
        LOCmat.materialList[ii].displacement_map_on = true -- BooleanClass
        LOCmat.materialList[ii].cutout_map_on = true -- BooleanClass
        LOCmat.materialList[ii].environment_map_on = true -- BooleanClass
        LOCmat.materialList[ii].add_color_map_on = true -- BooleanClass
        LOCmat.materialList[ii].radius_map_on = true -- BooleanClass
        LOCmat.materialList[ii].fg_quality_map_amt = 1.0 -- Float
        LOCmat.materialList[ii].bump_map_amt = 0.1 -- Float
        LOCmat.materialList[ii].displacement_map_amt = 1.0 -- Float
      )

      local LOCwaterMult = 1.0
      case units.SystemType of
      (
        #Inches      : LOCwaterMult = 39.3700787
        #Feet        : LOCwaterMult = 3.2808399
        #Miles       : LOCwaterMult = 0.000621371192
        #Millimeters : LOCwaterMult = 1000.0
        #Centimeters : LOCwaterMult = 100.0
        #Meters      : LOCwaterMult = 1.0
        #Kilometers  : LOCwaterMult = 0.001
      )

      --- Set Roughness (20 - calm)
      LOCmat.materialList[20].bump_map.Largest             = LOCwaterMult * 5.0 -- Float
      LOCmat.materialList[20].bump_map.Smallest            = LOCwaterMult * 0.2 -- Float
      LOCmat.materialList[20].bump_map.quantity            = 7 -- Integer
      LOCmat.materialList[20].bump_map.Steepness           = 0.25 -- Float
      LOCmat.materialList[20].bump_map.Relative_to_World   = true -- BooleanClass
      LOCmat.materialList[20].bump_map.Relative_to_Object  = false -- BooleanClass
      LOCmat.materialList[20].bump_map.Base_Plane_Normal   = [0,0,1] -- Point3
      LOCmat.materialList[20].bump_map.Base_Plane_Distance = 0.0 -- Float
      LOCmat.materialList[20].bump_map.Directed            = false -- BooleanClass
      LOCmat.materialList[20].bump_map.Direction_Angle     = 0.0 -- Float
      LOCmat.materialList[20].bump_map.Wave_Speed          = 0.6 -- Float
      LOCmat.materialList[20].bump_map.Loop_Animation      = true -- BooleanClass
      LOCmat.materialList[20].bump_map.Loop_Frames         = 100 -- Integer
      LOCmat.materialList[20].bump_map.Flats               = false -- BooleanClass
      LOCmat.materialList[20].bump_map.size                = 10.0 -- Float
      LOCmat.materialList[20].bump_map.variation           = 1.0 -- Float
      LOCmat.materialList[20].bump_map.Bump                = true -- BooleanClass

      --- Set Roughness (21 - medium)
      LOCmat.materialList[21].bump_map.Largest             = LOCwaterMult * 4.0 -- Float
      LOCmat.materialList[21].bump_map.Smallest            = LOCwaterMult * 0.15 -- Float
      LOCmat.materialList[21].bump_map.quantity            = 10 -- Integer
      LOCmat.materialList[21].bump_map.Steepness           = 1.0 -- Float
      LOCmat.materialList[21].bump_map.Relative_to_World   = true -- BooleanClass
      LOCmat.materialList[21].bump_map.Relative_to_Object  = false -- BooleanClass
      LOCmat.materialList[21].bump_map.Base_Plane_Normal   = [0,0,1] -- Point3
      LOCmat.materialList[21].bump_map.Base_Plane_Distance = 0.0 -- Float
      LOCmat.materialList[21].bump_map.Directed            = false -- BooleanClass
      LOCmat.materialList[21].bump_map.Direction_Angle     = 0.0 -- Float
      LOCmat.materialList[21].bump_map.Wave_Speed          = 0.8 -- Float
      LOCmat.materialList[21].bump_map.Loop_Animation      = true -- BooleanClass
      LOCmat.materialList[21].bump_map.Loop_Frames         = 100 -- Integer
      LOCmat.materialList[21].bump_map.Flats               = false -- BooleanClass
      LOCmat.materialList[21].bump_map.size                = 10.0 -- Float
      LOCmat.materialList[21].bump_map.variation           = 1.0 -- Float
      LOCmat.materialList[21].bump_map.Bump                = true -- BooleanClass
    )
    else
    (
      LOCmat[1]  = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[1]  (color 250 250 250) (color 250 250 250) (color 250 250 250) 1 LOCdiffMaps[1]  LOCbumpMaps[1]  LOCopacMaps[1]  100  0 1.0 false 15 35 0.00 0 100 false 0.0 false  1.0  1.0 0.0 0.0   LOCasphaltNoiseMap 10.0
      LOCmat[2]  = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[2]  (color 250 250 250) (color 250 250 250) (color 250 250 250) 1 LOCdiffMaps[2]  LOCbumpMaps[2]  LOCopacMaps[2]  100  0 1.0 false 15 35 0.00 0 100 false 0.0 false  1.0  2.0 0.0 0.25  LOCasphaltNoiseMap 10.0
      LOCmat[3]  = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[3]  (color 250 250 250) (color 250 250 250) (color 250 250 250) 1 LOCdiffMaps[3]  LOCbumpMaps[3]  LOCopacMaps[3]  100  0 1.0 false 15 35 0.00 0 100 false 0.0 false  1.0  3.0 0.0 0.0   LOCasphaltNoiseMap 10.0
      LOCmat[4]  = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[4]  (color 250 250 250) (color 250 250 250) (color 250 250 250) 1 LOCdiffMaps[4]  LOCbumpMaps[4]  LOCopacMaps[4]  100  0 1.0 false 15 35 0.00 0 100 false 0.0 false  1.0  4.0 0.0 0.125 LOCasphaltNoiseMap 10.0
      LOCmat[5]  = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[5]  (color 250 250 250) (color 250 250 250) (color 250 250 250) 1 LOCdiffMaps[5]  LOCbumpMaps[5]  LOCopacMaps[5]  100  0 1.0 false 15 35 0.00 0 100 false 0.0 false  1.0  5.0 0.0 0.0   LOCasphaltNoiseMap 10.0
      LOCmat[6]  = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[6]  (color 250 250 250) (color 250 250 250) (color 250 250 250) 1 LOCdiffMaps[6]  LOCbumpMaps[6]  LOCopacMaps[6]  100  0 1.0 false 15 35 0.00 0 100 false 0.0 false  5.0  1.0 0.0 0.0   LOCasphaltNoiseMap 10.0
      LOCmat[7]  = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[7]  (color 250 250 250) (color 250 250 250) (color 250 250 250) 1 LOCdiffMaps[7]  LOCbumpMaps[7]  LOCopacMaps[7]  100  0 1.0 false 15 35 0.00 0 100 false 0.0 false  2.0  2.0 0.0 0.0   LOCasphaltNoiseMap 10.0
      LOCmat[8]  = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[8]  (color 250 250 250) (color 250 250 250) (color 250 250 250) 1 LOCdiffMaps[8]  LOCbumpMaps[8]  LOCopacMaps[8]  100  0 1.0 false 15 35 0.00 0 100 false 0.0 false  1.0  1.0 0.0 0.0   LOCasphaltNoiseMap 10.0
      LOCmat[9]  = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[9]  (color 250 250 250) (color 250 250 250) (color 250 250 250) 1 LOCdiffMaps[9]  LOCbumpMaps[9]  LOCopacMaps[9]  100  0 1.0 false 15 35 0.00 0 100 false 0.0 false  1.0  2.0 0.0 0.25  LOCasphaltNoiseMap 10.0
      LOCmat[10] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[10] (color 250 250 250) (color 250 250 250) (color 250 250 250) 1 LOCdiffMaps[10] LOCbumpMaps[10] LOCopacMaps[10] 100  0 1.0 false 15 35 0.00 0 100 false 0.0 false  1.0  3.0 0.0 0.0   LOCasphaltNoiseMap 10.0
      LOCmat[11] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[11] (color 250 250 250) (color 250 250 250) (color 250 250 250) 1 LOCdiffMaps[11] LOCbumpMaps[11] LOCopacMaps[11] 100  0 1.0 false 15 35 0.00 0 100 false 0.0 false  1.0  4.0 0.0 0.125 LOCasphaltNoiseMap 10.0
      LOCmat[12] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[12] (color 250 250 250) (color 250 250 250) (color 250 250 250) 1 LOCdiffMaps[12] LOCbumpMaps[12] LOCopacMaps[12] 100  0 1.0 false 15 35 0.00 0 100 false 0.0 false  1.0  5.0 0.0 0.0   LOCasphaltNoiseMap 10.0
      LOCmat[13] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[13] (color 250 250 250) (color 250 250 250) (color 250 250 250) 1 LOCdiffMaps[13] LOCbumpMaps[13] LOCopacMaps[13] 100  0 1.0 false 15 35 0.00 0 100 false 0.0 false  1.0  1.0 0.0 0.0   LOCasphaltNoiseMap 10.0
      LOCmat[14] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[14] (color 250 250 250) (color 250 250 250) (color 250 250 250) 1 LOCdiffMaps[14] LOCbumpMaps[14] LOCopacMaps[14] 100  0 1.0 false 15 35 0.00 0 100 false 0.0 false  1.0  2.0 0.0 0.25  LOCasphaltNoiseMap 10.0
      LOCmat[15] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[15] (color 250 250 250) (color 250 250 250) (color 250 250 250) 1 LOCdiffMaps[15] LOCbumpMaps[15] LOCopacMaps[15] 100  0 1.0 false 15 35 0.00 0 100 false 0.0 false  1.0  3.0 0.0 0.0   LOCasphaltNoiseMap 10.0
      LOCmat[16] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[16] (color 250 250 250) (color 250 250 250) (color 250 250 250) 1 LOCdiffMaps[16] LOCbumpMaps[16] LOCopacMaps[16] 100  0 1.0 false 15 35 0.00 0 100 false 0.0 false  1.0  4.0 0.0 0.125 LOCasphaltNoiseMap 10.0
      LOCmat[17] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[17] (color 250 250 250) (color 250 250 250) (color 250 250 250) 1 LOCdiffMaps[17] LOCbumpMaps[17] LOCopacMaps[17] 100  0 1.0 false 15 35 0.00 0 100 false 0.0 false  1.0  5.0 0.0 0.0   LOCasphaltNoiseMap 10.0
      LOCmat[18] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[18] (color 250 250 250) (color 250 250 250) (color 250 250 250) 1 LOCdiffMaps[18] LOCbumpMaps[18] LOCopacMaps[18] 100  0 1.0 false 15 35 0.00 0 100 false 0.0 false  2.0  2.0 0.0 0.0   LOCasphaltNoiseMap 10.0
      LOCmat[19] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[19] (color 110  65  65) (color 110  65  65) (color 250 250 250) 1 LOCdiffMaps[19] LOCbumpMaps[19] LOCopacMaps[19]  90  0 1.0 false 15 35 0.00 0 100 false 0.0 false  5.0  5.0 0.0 0.0   LOCasphaltNoiseMap 10.0
      LOCmat[20] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[20] (color  50  72  50) (color  50  72  50) (color 218 216 240) 3 LOCdiffMaps[20] LOCbumpMaps[20] LOCopacMaps[20]  90 18 1.0 false 75  5 0.00 0 100 false 0.0 false  1.0  1.0 0.0 0.0   undefined 0.0
      LOCmat[21] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[21] (color   1  28   0) (color  50  72  50) (color 218 216 240) 3 LOCdiffMaps[21] LOCbumpMaps[21] LOCopacMaps[21]  90 18 1.0 false 75  5 0.00 0 100 false 0.0 false  1.0  1.0 0.0 0.0   undefined 0.0
      LOCmat[22] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[22] (color 105 105 105) (color 105 105 105) (color 229 229 229) 1 LOCdiffMaps[22] LOCbumpMaps[22] LOCopacMaps[22] 100 35 1.0 false 15 35 0.25 0 100 false 0.0 false  8.0  8.0 0.0 0.0   LOCconcreteNoiseMap 15.0
      LOCmat[23] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[23] (color 128 128 128) (color 128 128 128) (color 229 229 229) 4 LOCdiffMaps[23] LOCbumpMaps[23] LOCopacMaps[23] 100 35 1.0 false  5 25 0.10 0 100 false 0.0 false  1.0  1.0 0.0 0.0   undefined 0.0
      LOCmat[24] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[24] (color 147  44  56) (color 147  44  56) (color 229 229 229) 4 LOCdiffMaps[24] LOCbumpMaps[24] LOCopacMaps[24] 100 35 1.0 false  5 25 0.10 0 100 false 0.0 false  1.0  1.0 0.0 0.0   undefined 0.0
      LOCmat[25] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[25] DYNINImarkingColor  DYNINImarkingColor  DYNINImarkingColor  1 LOCdiffMaps[25] LOCbumpMaps[25] LOCopacMaps[25] 100  0 1.0 false  5 25 0.20 0 100 false 0.0 false  5.0  5.0 0.0 0.0   LOCasphaltNoiseMap 10.0
      LOCmat[26] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[26] (color 160 140 105) (color 100 185  80) (color 100 185  80) 2 LOCdiffMaps[26] LOCbumpMaps[26] LOCopacMaps[26] 100  0 0.8 false 13 17 0.10 0 100 false 0.0 false  0.1  0.1 0.0 0.0   LOCgrassNoiseMap 75.0
      LOCmat[27] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[27] (color 160 140 105) (color 100 185  80) (color 100 185  80) 2 LOCdiffMaps[27] LOCbumpMaps[27] LOCopacMaps[27] 100  0 0.8 false 13 17 0.10 0 100 false 0.0 false  0.1  0.1 0.0 0.0   LOCgrassNoiseMap 75.0
      LOCmat[28] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[28] (color 160 140 105) (color 100 185  80) (color 100 185  80) 2 LOCdiffMaps[28] LOCbumpMaps[28] LOCopacMaps[28] 100  0 0.8 false 13 17 0.10 0 100 false 0.0 false  0.1  0.1 0.0 0.0   LOCgrassNoiseMap 75.0
      LOCmat[29] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[29] (color 210 210 210) (color 210 210 210) (color 255 255 255) 1 LOCdiffMaps[29] LOCbumpMaps[29] LOCopacMaps[29] 100  0 0.5 false  0  0 0.20 0 100 false 0.0 false  5.0  1.0 0.0 0.0   undefined 0.0
      LOCmat[30] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[30] (color 210 210 210) (color 210 210 210) (color 255 255 255) 1 LOCdiffMaps[30] LOCbumpMaps[30] LOCopacMaps[30] 100  0 0.5 false  0  0 0.20 0 100 false 0.0 false  8.0  1.0 0.0 0.0   undefined 0.0
      LOCmat[31] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[31] (color  75 110  70) (color  75 110  70) (color  75 110  70) 1 LOCdiffMaps[31] LOCbumpMaps[31] LOCopacMaps[31] 100  0 0.6 false 13 17 0.10 0 100 false 0.0 false 20.0 20.0 0.0 0.0   undefined 0.0
      LOCmat[32] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[32] (color 130  95  85) (color 130  95  85) (color 130  95  85) 1 LOCdiffMaps[32] LOCbumpMaps[32] LOCopacMaps[32] 100 40 0.8 false  5 25 0.10 0 100 false 0.0 false  2.0  2.0 0.0 0.0   LOCgrassNoiseMap 30.0
      LOCmat[33] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[33] (color 130  95  85) (color 130  95  85) (color 130  95  85) 1 LOCdiffMaps[33] LOCbumpMaps[33] LOCopacMaps[33] 100 40 1.0 false 50 50 0.10 0 100 false 0.0 false  1.0  1.0 0.0 0.0   undefined 0.0
      LOCmat[34] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[34] (color 160 140 105) (color 100 185  80) (color 100 185  80) 2 LOCdiffMaps[34] LOCbumpMaps[34] LOCopacMaps[34] 100 40 1.0 false 13 17 0.50 0 100 false 0.0 false  4.0  4.0 0.0 0.0   LOCgrassNoiseMap 25.0
      LOCmat[35] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[35] (color 160 140 105) (color 100 185  80) (color 100 185  80) 5 LOCdiffMaps[35] LOCbumpMaps[35] LOCopacMaps[35] 100 40 1.0 false  6 20 0.50 0 100 false 0.0 false  4.0  4.0 0.0 0.0   LOCgrassNoiseMap 25.0
      LOCmat[36] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[36] (color 219 220 145) (color 219 220 145) (color 219 220 145) 5 LOCdiffMaps[36] LOCbumpMaps[36] LOCopacMaps[36] 100 40 1.0 false  5 15 0.10 0 100 false 0.0 false  2.0  2.0 0.0 0.0   LOCsandSmokeMap 30.0
      LOCmat[37] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[37] (color 105 105 105) (color 105 105 105) (color 229 229 229) 1 LOCdiffMaps[37] LOCbumpMaps[37] LOCopacMaps[37] 100 35 1.0 false 15 35 0.25 0 100 false 0.0 false  8.0  8.0 0.0 0.0   LOCconcreteNoiseMap 15.0
      LOCmat[38] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[38] (color 105 105 105) (color 105 105 105) (color 129 129 129) 1 LOCdiffMaps[38] LOCbumpMaps[38] LOCopacMaps[38] 100 35 1.0 false 15 35 0.25 0 100 false 0.0 false  9.0  9.0 0.0 0.0   LOCconcreteNoiseMap 15.0
      LOCmat[39] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[39] (color 185 175 175) (color 185 175 175) (color 229 229 229) 1 LOCdiffMaps[39] LOCbumpMaps[39] LOCopacMaps[39] 100 35 1.0 false 15 35 0.25 0 100 false 0.0 false  4.0  4.0 0.0 0.0   undefined 0.0
      LOCmat[40] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[40] (color 145 145 145) (color 145 145 145) (color 229 229 229) 1 LOCdiffMaps[40] LOCbumpMaps[40] LOCopacMaps[40] 100 35 1.0 false 15 35 0.25 0 100 false 0.0 false  4.0  4.0 0.0 0.0   undefined 0.0
      LOCmat[41] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[41] (color 175 165 165) (color 175 165 165) (color 180 170 170) 5 LOCdiffMaps[41] LOCbumpMaps[41] LOCopacMaps[41] 100 35 1.0 false  5 25 0.10 0 100 false 0.0 false 10.0 10.0 0.0 0.0   LOCpavingNoiseMap 10.0
      LOCmat[42] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[42] (color 175 165 165) (color 175 165 165) (color 180 170 170) 5 LOCdiffMaps[42] LOCbumpMaps[42] LOCopacMaps[42] 100 35 1.0 false  5 25 0.10 0 100 false 0.0 false 10.0 10.0 0.0 0.0   LOCpavingNoiseMap 10.0
      LOCmat[43] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[43] (color 175 165 165) (color 175 165 165) (color 180 170 170) 5 LOCdiffMaps[43] LOCbumpMaps[43] LOCopacMaps[43] 100 35 1.0 false  5 25 0.10 0 100 false 0.0 false 10.0 10.0 0.0 0.0   LOCpavingNoiseMap 10.0
      LOCmat[44] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[44] (color 175 165 165) (color 175 165 165) (color 180 170 170) 5 LOCdiffMaps[44] LOCbumpMaps[44] LOCopacMaps[44] 100 35 1.0 false  5 25 0.10 0 100 false 0.0 false 10.0 10.0 0.0 0.0   LOCpavingNoiseMap 10.0
      LOCmat[45] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[45] (color 175 165 165) (color 175 165 165) (color 180 170 170) 5 LOCdiffMaps[45] LOCbumpMaps[45] LOCopacMaps[45] 100 35 1.0 false  5 25 0.10 0 100 false 0.0 false 10.0 10.0 0.0 0.0   LOCpavingNoiseMap 10.0
      LOCmat[46] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[46] (color 175 165 165) (color 175 165 165) (color 180 170 170) 5 LOCdiffMaps[46] LOCbumpMaps[46] LOCopacMaps[46] 100 35 1.0 false  5 25 0.10 0 100 false 0.0 false 10.0 10.0 0.0 0.0   LOCpavingNoiseMap 10.0
      LOCmat[47] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[47] (color 175 165 165) (color 175 165 165) (color 180 170 170) 5 LOCdiffMaps[47] LOCbumpMaps[47] LOCopacMaps[47] 100 35 1.0 false  5 25 0.10 0 100 false 0.0 false 10.0 10.0 0.0 0.0   LOCpavingNoiseMap 10.0
      LOCmat[48] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[48] (color 175 165 165) (color 175 165 165) (color 180 170 170) 5 LOCdiffMaps[48] LOCbumpMaps[48] LOCopacMaps[48] 100 35 1.0 false  5 25 0.10 0 100 false 0.0 false 10.0 10.0 0.0 0.0   LOCpavingNoiseMap 10.0
      LOCmat[49] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[49] (color 175 165 165) (color 175 165 165) (color 180 170 170) 5 LOCdiffMaps[49] LOCbumpMaps[49] LOCopacMaps[49] 100 35 1.0 false  5 25 0.10 0 100 false 0.0 false 20.0 20.0 0.0 0.0   LOCpavingNoiseMap 10.0
      LOCmat[50] = DYNFUNbuildStdMat DYNuiResourcesSurfaceMaterial[50] (color 175 165 165) (color 175 165 165) (color 180 170 170) 5 LOCdiffMaps[50] LOCbumpMaps[50] LOCopacMaps[50] 100 35 1.0 false  5 25 0.10 0 100 false 0.0 false 10.0 10.0 0.0 0.0   LOCpavingNoiseMap 10.0

      --- Extra Bits: 31
      LOCmat.materiallist[31].diffuseMap                   = checker()
      LOCmat.materiallist[31].diffuseMap.coords.U_tiling   = 20.0
      LOCmat.materiallist[31].diffuseMap.coords.V_tiling   = 20.0

      --- Paving Type 1 Channel (23)
      LOCmat.materialList[23].diffuseMap                   = Bricks()
      LOCmat.materialList[23].diffuseMap.brick_color       = color 130 125 119
      LOCmat.materialList[23].diffuseMap.horizontal_count  = 12.0
      LOCmat.materialList[23].diffuseMap.vertical_count    = 32.0
      LOCmat.materialList[23].diffuseMap.color_variance    = 0.1
      LOCmat.materialList[23].diffuseMap.fade_variance     = 0.1
      LOCmat.materialList[23].diffuseMap.mortar_color      = color 72 66 54
      LOCmat.materialList[23].diffuseMap.horizontal_gap    = 0.1
      LOCmat.materialList[23].diffuseMap.vertical_gap      = 0.1
      LOCmat.materialList[23].diffuseMap.lock_gap_symmetry = 1
      LOCmat.materialList[23].diffuseMap.holes             = 0
      LOCmat.materialList[23].diffuseMap.edge_roughness    = 5.0
      LOCmat.materialList[23].diffuseMap.random_seed       = 41955
      LOCmat.materiallist[23].diffuseMap.coords.W_angle    = 90.0
      LOCmat.materialList[23].diffuseMap.tile_type         = 1 -- Running Bond
      LOCmat.materialList[23].bumpMap                      = Bricks()
      LOCmat.materialList[23].bumpMap.brick_color          = color 215 215 215
      LOCmat.materialList[23].bumpMap.horizontal_count     = 12.0
      LOCmat.materialList[23].bumpMap.vertical_count       = 32.0
      LOCmat.materialList[23].bumpMap.color_variance       = 0.0
      LOCmat.materialList[23].bumpMap.fade_variance        = 0.0
      LOCmat.materialList[23].bumpMap.mortar_color         = color 44 37 23
      LOCmat.materialList[23].bumpMap.horizontal_gap       = 0.1
      LOCmat.materialList[23].bumpMap.vertical_gap         = 0.1
      LOCmat.materialList[23].bumpMap.lock_gap_symmetry    = 1
      LOCmat.materialList[23].bumpMap.holes                = 0
      LOCmat.materialList[23].bumpMap.edge_roughness       = 2.0
      LOCmat.materialList[23].bumpMap.random_seed          = 41955
      LOCmat.materiallist[23].bumpMap.coords.W_angle       = 90.0
      LOCmat.materialList[23].bumpMap.tile_type            = 1 -- Running Bond

      --- Paving Type 2 Channel (24)
      LOCmat.materialList[24].diffuseMap                   = Bricks()
      LOCmat.materialList[24].diffuseMap.brick_color       = color 121 52 57
      LOCmat.materialList[24].diffuseMap.horizontal_count  = 50.0
      LOCmat.materialList[24].diffuseMap.vertical_count    = 35.0
      LOCmat.materialList[24].diffuseMap.color_variance    = 0.1
      LOCmat.materialList[24].diffuseMap.fade_variance     = 0.2
      LOCmat.materialList[24].diffuseMap.mortar_color      = color 56 51 42
      LOCmat.materialList[24].diffuseMap.horizontal_gap    = 0.1
      LOCmat.materialList[24].diffuseMap.vertical_gap      = 0.1
      LOCmat.materialList[24].diffuseMap.lock_gap_symmetry = 1
      LOCmat.materialList[24].diffuseMap.holes             = 0
      LOCmat.materialList[24].diffuseMap.edge_roughness    = 5.0
      LOCmat.materialList[24].diffuseMap.random_seed       = 41955
      LOCmat.materialList[24].diffuseMap.tile_type         = 1 -- Running Bond
      LOCmat.materialList[24].bumpMap                      = Bricks()
      LOCmat.materialList[24].bumpMap.brick_color          = color 215 215 215
      LOCmat.materialList[24].bumpMap.horizontal_count     = 50.0
      LOCmat.materialList[24].bumpMap.vertical_count       = 35.0
      LOCmat.materialList[24].bumpMap.color_variance       = 0.0
      LOCmat.materialList[24].bumpMap.fade_variance        = 0.0
      LOCmat.materialList[24].bumpMap.mortar_color         = color 44 37 24
      LOCmat.materialList[24].bumpMap.horizontal_gap       = 0.1
      LOCmat.materialList[24].bumpMap.vertical_gap         = 0.1
      LOCmat.materialList[24].bumpMap.lock_gap_symmetry    = 1
      LOCmat.materialList[24].bumpMap.holes                = 0
      LOCmat.materialList[24].bumpMap.edge_roughness       = 2.0
      LOCmat.materialList[24].bumpMap.random_seed          = 41955
      LOCmat.materialList[24].bumpMap.tile_type            = 1 -- Running Bond

      LOCmat.materiallist[20].anisotropy             = 60
      LOCmat.materiallist[20].orientation            = 45
      LOCmat.materiallist[20].specular2              = color 155 195 150
      LOCmat.materiallist[20].specularLevel2         = 65
      LOCmat.materiallist[20].glossiness2            = 30
      LOCmat.materiallist[20].anisotropy2            = 55
      LOCmat.materiallist[20].orientation2           = -60
      LOCmat.materiallist[20].adTextureLock          = true -- (Lock betwwen Ambient/Diffuse Texture Maps)
      LOCmat.materiallist[20].useSelfIllumColor      = true
      LOCmat.materiallist[20].SelfIllumColor         = color 0 0 0
      LOCmat.materialList[20].diffuseMap             = Noise()
      LOCmat.materialList[20].diffuseMapAmount       = 90
      LOCmat.materialList[20].diffuseMap.name        = DYNuiResourcesMaterialMaps[6]
      LOCmat.materialList[20].diffuseMap.type        = 0 -- (0:Regular; 1:Fractal; 2:Turbulance)
      LOCmat.materialList[20].diffuseMap.phase       = 0.0
      LOCmat.materialList[20].diffuseMap.levels      = 3.0
      LOCmat.materialList[20].diffuseMap.size        = 60.0
      LOCmat.materialList[20].diffuseMap.color1      = color 31 69 26
      LOCmat.materialList[20].diffuseMap.color2      = color 57 80 57
      LOCmat.materialList[20].bumpMap                = smoke()
      LOCmat.materialList[20].bumpMapAmount          = 18
      LOCmat.materialList[20].bumpMapEnable          = true
      LOCmat.materialList[20].bumpMap.name           = DYNuiResourcesMaterialMaps[7]
      LOCmat.materialList[20].bumpMap.size           = 2.5
      LOCmat.materialList[20].bumpMap.iterations     = 4
      LOCmat.materialList[20].bumpMap.phase          = 0.0
      LOCmat.materialList[20].bumpMap.exponent       = 0.2
      LOCmat.materialList[20].bumpMap.color1         = color   0   0   0
      LOCmat.materialList[20].bumpMap.color2         = color 229 229 229
      LOCmat.materialList[20].bumpMap.coords.blur    = 1.0
      LOCmat.materialList[20].ReflectionMap          = raytrace()
      LOCmat.materialList[20].ReflectionMapAmount    = 65
      LOCmat.materialList[20].ReflectionMap.parameters.background_color = color 90 95 165
      LOCmat.materialList[20].ReflectionMap.parameters.Background_Mode  = 1 -- UseColor
      LOCmat.materialList[20].ReflectionMap.parameters.Attenuation_Mode = 1
      LOCmat.materialList[20].RefractionMap          = Smoke()
      LOCmat.materialList[20].RefractionMapAmount    = 45
      LOCmat.materialList[20].RefractionMap.name     = DYNuiResourcesMaterialMaps[8]
      LOCmat.materialList[20].RefractionMap.size     = 3.0
      LOCmat.materialList[20].RefractionMap.iterations  = 5
      LOCmat.materialList[20].RefractionMap.phase    = 0.0
      LOCmat.materialList[20].RefractionMap.exponent = 1.5
      LOCmat.materialList[20].RefractionMap.color1   = color   0   0   0
      LOCmat.materialList[20].RefractionMap.color2   = color  53  65  45
      LOCmat.materialList[20].RefractionMap.coords.blur = 1.0

      --- Rough Water Channel (21)
      LOCmat.materiallist[21].anisotropy             = 60
      LOCmat.materiallist[21].orientation            = 45
      LOCmat.materiallist[21].specular2              = color 155 195 150
      LOCmat.materiallist[21].specularLevel2         = 65
      LOCmat.materiallist[21].glossiness2            = 30
      LOCmat.materiallist[21].anisotropy2            = 55
      LOCmat.materiallist[21].orientation2           = -60
      LOCmat.materiallist[21].adTextureLock          = true -- (Lock betwwen Ambient/Diffuse Texture Maps)
      LOCmat.materiallist[21].useSelfIllumColor      = true
      LOCmat.materiallist[21].SelfIllumColor         = color 0 0 0
      LOCmat.materialList[21].diffuseMap             = Noise()
      LOCmat.materialList[21].diffuseMap.type        = 0 -- (0:Regular; 1:Fractal; 2:Turbulance)
      LOCmat.materialList[21].diffuseMap.phase       = 0.0
      LOCmat.materialList[21].diffuseMap.levels      = 3.0
      LOCmat.materialList[21].diffuseMap.size        = 60.0
      LOCmat.materialList[21].diffuseMap.color1      = color 31 69 26
      LOCmat.materialList[21].diffuseMap.color2      = color 57 80 57
      LOCmat.materialList[21].bumpMap                = smoke()
      LOCmat.materialList[21].bumpMapAmount          = 18
      LOCmat.materialList[21].bumpMapEnable          = true
      LOCmat.materialList[21].bumpMap.name           = DYNuiResourcesMaterialMaps[7]
      LOCmat.materialList[21].bumpMap.size           = 2.5
      LOCmat.materialList[21].bumpMap.iterations     = 4
      LOCmat.materialList[21].bumpMap.phase          = 0.0
      LOCmat.materialList[21].bumpMap.exponent       = 0.2
      LOCmat.materialList[21].bumpMap.color1         = color   0   0   0
      LOCmat.materialList[21].bumpMap.color2         = color 229 229 229
      LOCmat.materialList[21].bumpMap.coords.blur    = 1.0
      LOCmat.materialList[21].ReflectionMap          = raytrace()
      LOCmat.materialList[21].ReflectionMapAmount    = 65
      LOCmat.materialList[21].ReflectionMap.parameters.background_color = color 90 95 165
      LOCmat.materialList[21].ReflectionMap.parameters.Background_Mode  = 1 -- UseColor
      LOCmat.materialList[21].ReflectionMap.parameters.Attenuation_Mode = 1
      LOCmat.materialList[21].RefractionMap          = Smoke()
      LOCmat.materialList[21].RefractionMapAmount    = 45
      LOCmat.materialList[21].RefractionMap.name     = DYNuiResourcesMaterialMaps[8]
      LOCmat.materialList[21].RefractionMap.size     = 3.0
      LOCmat.materialList[21].RefractionMap.iterations  = 5
      LOCmat.materialList[21].RefractionMap.phase    = 0.0
      LOCmat.materialList[21].RefractionMap.exponent = 1.5
      LOCmat.materialList[21].RefractionMap.color1   = color   0   0   0
      LOCmat.materialList[21].RefractionMap.color2   = color  53  65  45
      LOCmat.materialList[21].RefractionMap.coords.blur = 1.0
    )

    --- Set Names In MultiMaterial
    for i = 1 to LOCmat.count do
    (
      LOCmat.names[i] = LOCmat.materialList[i].name
    )

    --- Attempt to Save Material To Civil View Material Library
    local LOCmatLibrary = materialLibrary LOCmat
    local LOCsuccess    = saveTempMaterialLibrary LOCmatLibrary LOCcivilViewSurfacesMatFile
  )

  --- Show Texture Maps In Viewport
  if classOf LOCmat == Multimaterial then (for i = 1 to LOCmat.count do (DYNFUNshowTextureMap LOCmat i false on))

  --- Return Finished Material Value
  LOCmat -- return value
)
